;*******************************
;*    DEMONTRATION PROGRAM 4   *
;*            MOTOR            *
;*******************************
;
            ORG    8000H
DIPSW       EQU    0E0A0H
U21PA       EQU    0E0B8H
U21PB       EQU    0E0B9H
U21PC       EQU    0E0BAH
U21CTRL     EQU    0E0BBH
U28PA       EQU    0E0B4H
U28PB       EQU    0E0B5H
U28PC       EQU    0E0B6H
U28CTRL     EQU    0E0B7H
SEG_PORT    EQU    U21PB
SCAN_KYDP   EQU    27H
BCD_HEX     EQU    5               ;System call
CLRSCR      EQU    7               ;   "     "
HI_BEEP     EQU    18H             ;   "     "
ONE_TO_TWO  EQU    1DH             ;   "     "
WAIT_2KEY   EQU    33H             ;   "     "
MOTORBUF    EQU    22H             ;Port buffer of relay
HI_PULSE    EQU    MOTORBUF+1
LO_PULSE    EQU    MOTORBUF+2
HI_DLY      EQU    MOTORBUF+3
LO_DLY      EQU    MOTORBUF+4
SYSCALL     EQU    0030H
DISBUF      EQU    9F00H

DEM41:      MOV    DPTR,#U28CTRL
            MOV    P2,DPH
            MOV    A,#81H
            MOVX   @DPTR,A
            MOV    DPTR,#U28PA
            MOV    R1,DPL           ;Relay port
            MOV    A,#0FFH
            MOVX   @DPTR,A
            INC    DPTR
            CLR    A
            MOVX   @DPTR,A
            MOV    MOTORBUF,A
            MOV    HI_PULSE,#50H
            MOV    LO_PULSE,#50H

START:      MOV    A,#CLRSCR        ;Clear screen
            LCALL  SYSCALL
            LCALL  PRINT
            ;Text "ProG-M"
            DB     73H,50H,5CH,3DH,40H,37H,00
WAIT_KEY:   MOV    A,#SCAN_KYDP
            LCALL  SYSCALL
            CJNE   A,#10H,CP11
            SJMP   PROG_M           ;Program speed motor
CP11:       CJNE   A,#12H,WAIT_KEY

RUN_MOTOR:  MOV    R4,#0
            MOV    R3,#0
            MOV    R2,HI_PULSE
            MOV    A,#BCD_HEX
            LCALL  SYSCALL
            MOV    HI_DLY,R2
            MOV    R2,LO_PULSE
            MOV    A,#BCD_HEX
            LCALL  SYSCALL
            MOV    LO_DLY,R2
            MOV    DPTR,#U28PC
            MOV    R0,DPL           ;P2:R0 = Port of motor
            MOV    R1,#2            ;P2:R1 = Port of keyboard
            MOV    A,#4
            MOVX   @R1,A            ;Active colum of keyboarf

R_M1:       MOV    B,HI_DLY
            MOV    A,#0CFH
            SETB   P1.0
            MOVX   @R0,A
R_M2:       LCALL  MSEC_DLY
            DJNZ   B,R_M2
            MOV    B,LO_DLY
            MOV    A,#4FH
            CLR    P1.0
            MOVX   @R0,A
R_M3:       LCALL  MSEC_DLY
            DJNZ   B,R_M3
            MOVX   A,@R1
            ANL    A,#70H
            CJNE   A,#70H,RE_PROG
            LJMP   R_M1
RE_PROG:    JB     ACC.6,R_M1

;*****************************************
;*        PROGRAM SPEED OF MORTOR        *
;*****************************************
;
PROG_M:     MOV    DPTR,#DISBUF
            MOV    A,#0F6H           ;"H"
            MOVX   @DPTR,A
            INC    DPTR
            MOV    B,HI_PULSE
            MOV    A,#ONE_TO_TWO
            LCALL  SYSCALL
            MOVX   @DPTR,A
            INC    DPTR
            MOV    A,B
            MOVX   @DPTR,A
            INC    DPTR
            MOV    A,#0B8H           ;"L"
            MOVX   @DPTR,A
            MOV    B,LO_PULSE
            MOV    A,#ONE_TO_TWO
            LCALL  SYSCALL
            INC    DPTR
            MOVX   @DPTR,A
            INC    DPTR
            MOV    A,B
            MOVX   @DPTR,A
            ;*
            ;* Whate key
            ;*
WHAT_KEY:   MOV    A,#SCAN_KYDP
            LCALL  SYSCALL
            PUSH   ACC
            MOV    A,#HI_BEEP
            LCALL  SYSCALL
            POP    ACC
            CJNE   A,#13H,DEC_KEY
            MOV    A,HI_PULSE
            CJNE   A,#99H,INC1
            SJMP   WHAT_KEY
INC1:       ADD    A,#1
            DA     A
            MOV    HI_PULSE,A
            MOV    A,LO_PULSE
            LCALL  DEC_BCD
            MOV    LO_PULSE,A
            SJMP   PROG_M

            ;* Decrease hi pulse
DEC_KEY:    CJNE   A,#12H,DEC_KEY1
            LJMP   RUN_MOTOR
DEC_KEY1:   CJNE   A,#11H,WHAT_KEY
            MOV    A,HI_PULSE
            CJNE   A,#1,DEC1
            SJMP   WHAT_KEY
DEC1:       LCALL  DEC_BCD
            MOV    HI_PULSE,A
            MOV    A,LO_PULSE
            ADD    A,#1
            DA     A
            MOV    LO_PULSE,A
            SJMP   PROG_M

;********************************
;*        Decrease BCD by 1     *
;* INPUT    ACC = BCD Value     *
;* OUTPUT   ACC = BCD-1         *
;********************************
;
DEC_BCD:    PUSH   B
            CLR    CY
            SUBB   A,#1
            MOV    B,A
            ANL    A,#0FH
            CJNE   A,#0AH,MORE9
MORE9:      JC     MORE99
            CLR    CY
            MOV    A,B
            SUBB   A,#6
            MOV    B,A
MORE99:     MOV    A,B
            ANL    A,#0F0H
            CJNE   A,#0A0H,MORE991
MORE991:    JC     ADJUST
            MOV    A,B           ;Hi nibble >9
            CLR    CY
            SUBB   A,#60H
            XCH    A,B
            ANL    A,#0FH
ADJUST:     ORL    A,B
            POP    B
            RET

;*****************************
;*        Delay 1 msec.      *
;* INPUT   B= Time(milli sec)*
;*****************************
;
MSEC_DLY:   MOV    DPTR,#65536-152
MD1:        INC    DPTR
            MOV    A,DPH
            ORL    A,DPL
            JNZ    MD1
            RET

;*****************************************
;*  Move data following "CALL PRINT_DSP" *
;*  to display buffer.                   *
;*  Usage: LCALL PRINT_DSP               *
;*         DB   'xxxx',00                *
;*  Register : R0                        *
;*  Note : End of text by fill to end 00 *
;*         Space on disply by code 20h.  *
;*****************************************
;
PRINT:      MOV    DPTR,#DISBUF
            MOV    P2,DPH
            MOV    R0,DPL         ;P2:R0 = Destination
            POP    DPH            ;Point to data to print
            POP    DPL
PRNTD1:     CLR    A
            MOVC   A,@A+DPTR
            JZ     END_PRN        ;End of text
            CJNE   A,#20H,PRNTD2
            CLR    A
PRNTD2:     MOVX   @R0,A          ;Write to display buffer
            INC    DPTR
            INC    R0
            SJMP   PRNTD1
END_PRN:    JMP    @A+DPTR        ;Return
            ;End of print
            ;Return to main

            END

